<!DOCTYPE html>
<html>
<head>
    <title>Account Ledger</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" />
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th, td {
            padding: 3px;
            border: 1px solid #ddd;
        }

        th {
            background-color: lightblue;
            text-align: left;
        }

        tbody tr:nth-child(even) {
            background-color: #F5F4F4;
        }

        tbody tr:hover {
            background-color: lightblue;
        }

        .swal2-icon-custom-size {
            font-size: 5px !important; /* Adjust the font-size as per your preference */
        }

        .ledger-row {
            user-select: none;
            cursor: default;
        }

        .action-button {
            padding: 4px 8px;
            background-color: #4CAF50;
            border: none;
            color: white;
            cursor: pointer;
        }

        .action-button:hover {
            background-color: #45a049;
        }

        .container {
            margin: 0 auto;
            max-width: 95%;
            padding: 20px;
        }

        .table-filter {
            margin-bottom: 20px;
        }

        #filterInput {
            width: 100%;
            padding: 5px;
            font-size: 16px;
        }

#printButton {
    background-color: lightblue;
     padding: 5px;
color: black;
  border: none;
height: 30px;
width: 50px;
  cursor: pointer;
  border-radius: 20%;
}

    </style>
</head>
<body>
<div class="container">

    <button  id="printButton" onclick="printPage()">Print</button>

    
    <br>

    <h1>Account Ledger</h1>


    <?php
    require 'connection.php';
    $accid = $_GET['accid'];
    $from = $_GET['from'];
    $to = $_GET['to'];
    $qry = "SELECT * FROM accreg WHERE accid = '$accid'";
    $run = mysqli_query($connect, $qry);
    $row = mysqli_fetch_array($run);
    $accId = $row['accid'];
    $name = $row['accname'];

    // finding opening balance
    $qry1 = "SELECT sum(debit) - sum(credit) AS cashOp FROM ledger WHERE accid = '$accid' AND dated < '$from'";
    $run_qry1 = mysqli_query($connect, $qry1);
    $row1 = mysqli_fetch_array($run_qry1);
    $cashOp = $row1['cashOp'];
    // end of opening balance

    // finding closing balance
    $qry2 = "SELECT sum(debit) - sum(credit) AS close, min(dated) AS firstdate, max(dated) AS lastdate FROM ledger WHERE accid = '$accid' AND dated <= '$to'";
    $run_qry2 = mysqli_query($connect, $qry2);
    $row2 = mysqli_fetch_array($run_qry2);
    $closingB = $row2['close'];

    $fdate = $row2['firstdate'];
    $dt1 = date_create($fdate);
    $fdt = date_format($dt1, "d-m-Y");

    $ldate = $row2['lastdate'];
    $dt2 = date_create($ldate);
    $ldt = date_format($dt2, "d-m-Y");

    $sum = 0;
    $bal = $cashOp;
    $debitT = 0;
    $creditT = 0;
    $qtyT = 0;
    ?>
  <br>
    <h3>Account Name: &nbsp;&nbsp;<?php echo $name; ?></h3>


    <div class="table-filter">

        <input type="text" id="filterInput" placeholder="Filter table...">
    </div>

    <table>
        <!-- <thead> -->
        <tr>
            <td style="color: black; font-size: 14px; text-align: center; font-family: Arial; border-color: white;"
                colspan="6">********Opening Balance********
            </td>
            <td colspan="2"
                style="text-align: right; color: black; font-size: 14px; border-right: 1px solid; border-right-color: white; border-color: white; text-align: center;"><?php echo number_format($cashOp); ?></td>
        </tr>
        <tr>
            <th>Date</th>
            <th>V.No</th>
            <th>Description</th>
            <th style="min-width: 70px;">Ref No</th>
            <th>Type</th>
            <th>Debit</th>
            <th>Credit</th>
            <th>Balance</th>
        </tr>
        <!-- </thead> -->

        <tbody>
        <?php
        $crtotal = 0;
        $credit = 0;
        $debit = 0;
        $qty = 0;
        $rowclr = 0;
        $rowclrs = 0;
        $drtotal = 0;
        $qtytotal = 0;
        $qry = "SELECT * FROM ledger WHERE accid = '$accid' AND dated >= '$from' AND dated <= '$to' AND itemid<=0 ORDER BY dated,trid ASC";
        $run_qry = mysqli_query($connect, $qry);
        while ($row = mysqli_fetch_array($run_qry)) {
            if ($row['credit'] !== '') {
                $credit = $row['credit'];
            }
            $crtotal = $crtotal + $credit;
            if ($row['debit'] !== '') {
                $debit = $row['debit'];
            }
            $drtotal = $drtotal + $debit;
            if ($row['qty'] !== '') {
                $qty = $row['qty'];
            }
            $qtytotal = $qtytotal + $qty;
            $itid = $row['itemid'];
            $selitem = "SELECT itemname FROM itemreg WHERE itemid = '$itid'";
            $itemrun = mysqli_query($connect, $selitem);
            $itemrow = mysqli_fetch_array($itemrun);
            ?>

            <tr style="border: none;" class="ledger-row">
                <td style="white-space: nowrap;">
                    <?php
                    $dt1 = date_create($row['dated']);
                    $fdt = date_format($dt1, "d-m-Y");
                    echo $fdt;
                    ?> 

                </td>
                <td><?php echo $row['vno']; ?></td>
                <td style=" font-family: Serif; font-style: normal;"><?php echo $row['description']; ?></td>
                <td><?php echo $row['refno']; ?></td>
                <td style="white-space: nowrap;"><?php echo $row['entrytype']; ?></td>
                <td><?php echo $row['debit']; ?></td>
                <td><?php echo $row['credit']; ?></td>
                <td><?php echo number_format($bal = $bal + $debit - $credit); ?></td>
            </tr>
        <?php } ?>
        </tbody>

        <!-- <tfoot> -->
        <tr>
            <td style="color: black; font-size: 14px; text-align: center; font-family: Arial; border-color: white;"
                colspan="6">********Closing Balance********
            </td>
            <td colspan="2"
                style="text-align: right; color: black; font-size: 14px; border-right: 1px solid; border-right-color: white; border-color: white; text-align: center;"><?php echo number_format($closingB); ?></td>
        </tr>
        <!-- </tfoot> -->
    </table>
</div>



<script>
    function showDescription(description) {
        Swal.fire({
            title: 'Description',
            text: description,
            icon: 'info',
            confirmButtonText: 'OK'
        });
    }

    function showDetails(description, entryType, vno, dated) {
        const xhr = new XMLHttpRequest();
        const url = 'detailpage.php';
        // const params = `description=${encodeURIComponent(description)}&entryType=${encodeURIComponent(entryType)}&vno=${encodeURIComponent(vno)}&dated=${encodeURIComponent(dated)}`;

const params = `entryType=${encodeURIComponent(entryType)}&vno=${encodeURIComponent(vno)}&dated=${encodeURIComponent(dated)}&description=${description}`;

        xhr.open('GET', 'detailpage.php?dated=' + dated + '&entryType=' + entryType+ '&vno=' + vno+'&description=' + description, true);

        xhr.onload = function () {
            if (xhr.status === 200) {
                const response = xhr.responseText;
                Swal.fire({
                    title: 'Details',
                    html: response,
                    icon: 'info',
                    confirmButtonText: 'OK',
                    allowOutsideClick: false,
                      customClass: {
                icon: 'swal2-icon-custom-size' // Add a custom class for the icon
            }
                });
            }
        };

        xhr.send();
    }

    // Get all the table rows
    const tableRows = document.querySelectorAll('tbody tr');

    // Attach a click event listener to each table row
    tableRows.forEach(row => {
        row.addEventListener('click', () => {
            const description = row.querySelector('td:nth-child(3)').textContent;
            const entryType = row.querySelector('td:nth-child(5)').textContent;
            const vno = row.querySelector('td:nth-child(2)').textContent;
            const dated = row.querySelector('td:nth-child(1)').textContent;
            showDetails(description, entryType, vno, dated);
        });
    });


    // Get the filter input element
        const filterInput = document.getElementById('filterInput');

        // Add event listener for input change
        filterInput.addEventListener('input', function() {
            const filterValue = filterInput.value.toLowerCase();
            const tableRows = document.querySelectorAll('.ledger-row');

            tableRows.forEach(row => {
                const description = row.querySelector('td:nth-child(3)').textContent.toLowerCase();
                const entryType = row.querySelector('td:nth-child(5)').textContent.toLowerCase();
                const vno = row.querySelector('td:nth-child(2)').textContent.toLowerCase();
                const dated = row.querySelector('td:nth-child(1)').textContent.toLowerCase();

                if (description.includes(filterValue) || entryType.includes(filterValue) || vno.includes(filterValue) || dated.includes(filterValue)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
</script>


<script type="text/javascript">
// Function to hide the search/filter input box and print button
function hideSearchAndPrint() {
  const filterInput = document.getElementById('filterInput');
  const printButton = document.getElementById('printButton');
  filterInput.style.display = 'none';
  printButton.style.display = 'none';
}

// Function to show the search/filter input box and print button
function showSearchAndPrint() {
  const filterInput = document.getElementById('filterInput');
  const printButton = document.getElementById('printButton');
  filterInput.style.display = '';
  printButton.style.display = '';
}

// Function to print the page
function printPage() {
  hideSearchAndPrint(); // Hide the search/filter input box and print button
  window.print(); // Open the print dialog
}

// Event listener to detect when the print dialog is closed
window.addEventListener('afterprint', function() {
  showSearchAndPrint(); // Show the search/filter input box and print button
});




// Event listener to prevent direct printing using Ctrl+P
window.addEventListener('keydown', function(event) {
  if (event.ctrlKey && (event.key === 'p' || event.key === 'P')) {
    event.preventDefault();
    console.log("Direct printing using Ctrl+P is disabled.");
  }
});

// Event listener to prevent right-clicking
window.addEventListener('contextmenu', function(event) {
  event.preventDefault();
  console.log("Right-clicking is disabled.");
});


// Event listener to prevent F12 key
window.addEventListener('keydown', function(event) {
  if (event.key === 'F12') {
    event.preventDefault();
    console.log("Opening Developer Console (F12) is disabled.");
  }
});
</script>


</body>
</html>
