<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Add these lines in the head section -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <title>Account Ledger Report</title>
    <style>
      table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th, td {
            padding: 3px;
            border: 1px solid #ddd;
        }

        th {
            background-color: lightblue;
            text-align: left;
        }

        tbody tr:nth-child(even) {
            background-color: #F5F4F4;
        }

        tbody tr:hover {
            background-color: lightblue;
        }

        .swal2-icon-custom-size {
            font-size: 5px !important; /* Adjust the font-size as per your preference */
        }

        .ledger-row {
            user-select: none;
            cursor: default;
        }

        .action-button {
            padding: 4px 8px;
            background-color: #4CAF50;
            border: none;
            color: white;
            cursor: pointer;
        }

        .action-button:hover {
            background-color: #45a049;
        }

        .container {
            margin: 0 auto;
            max-width: 95%;
            padding: 20px;
        }

        .table-filter {
            margin-bottom: 20px;
        }

        #filterInput {
            width: 100%;
            padding: 5px;
            font-size: 16px;
        }

#printButton {
    background-color: lightblue;
     padding: 5px;
color: black;
  border: none;
height: 30px;
width: 50px;
  cursor: pointer;
  border-radius: 20%;
}



    @media print {
        #printButton {
            display: none;
        }
    }
    </style>
</head>

<body>
<div class="container">
    <button  id="printButton" onclick="printPage()">Print</button>

    
    <br>


<?php

// Get "from" and "to" dates from PHP variables

        $accid= $_GET['accid'];
        $fromDate= $_GET['from'];
        $toDate= $_GET['to'];
        require 'connection.php';


   $qry = "SELECT * FROM accreg WHERE accid = '$accid'";
    $run = mysqli_query($connect, $qry);
    $row = mysqli_fetch_array($run);
    $accId = $row['accid'];
    $name = $row['accname'];

    // finding opening balance
    $qry1 = "SELECT sum(debit) - sum(credit) AS cashOp FROM ledger WHERE accid = '$accid' AND dated < '$fromDate'";
    $run_qry1 = mysqli_query($connect, $qry1);
    $row1 = mysqli_fetch_array($run_qry1);
    $cashOp = $row1['cashOp'];

    ?>
    <h1>Account Ledger</h1>

<h3><?php echo $name; ?></h3>
    <?php
    // end of opening balance

// Create connection
$conn = $connect;

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Prepare SQL query with date range filter
$sql = "SELECT dated, vno, description, debit, credit,entrytype,refno FROM ledger WHERE dated BETWEEN '$fromDate' AND '$toDate' and accid='$accid' ORDER BY dated, vno,trid";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $runningBalance = $cashOp;

    ?>
    <table>

            <tr>
                <th  style="min-width: 80px; max-width: 80px;">Date</th>
                <th>V.No</th>
                <th style="min-width: 300px;">Description</th>
                <th>Ref.No</th>
                <th>Transaction</th>
                <th>Debit</th>
                <th>Credit</th>
                <th>Balance</th>
            </tr>
<?php
    // Opening balance row

?>

<tr style="background-color: white; border: none; border-color: white;">
            <td style="text-align: center;" colspan="7">Opening Balance</td>
          
            <td style="text-align: left;"><?php echo $runningBalance; ?></td>
          </tr>
<?php



    // Output data of each row
    while($row = $result->fetch_assoc()) {
        $runningBalance += ($row["debit"] - $row["credit"]);
  echo "<tr data-toggle='modal' data-target='#ledgerModal' data-dated='{$row["dated"]}' data-vno='{$row["vno"]}' data-description='{$row["description"]}' data-debit='{$row["debit"]}' data-credit='{$row["credit"]}'>
    
                <td>{$row["dated"]}</td>
                <td>{$row["vno"]}</td>
                <td>{$row["description"]}</td>
                <td>{$row["refno"]}</td>
                <td>{$row["entrytype"]}</td>
                <td>{$row["debit"]}</td>
                <td>{$row["credit"]}</td>
                <td>{$runningBalance}</td>
              </tr>";
    }
?>

<?php
 

    echo "</table>";
?>
   <h3 style="float: right;"><?php echo 'Balance: '.$runningBalance; ?></h3>;

<?php
} else {
    echo "0 results";
}


$conn->close();
?>

<!-- Add this modal after your table -->
<div class="modal fade" id="ledgerModal" tabindex="-1" role="dialog" aria-labelledby="ledgerModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="ledgerModalLabel">Ledger Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="modalBody">
                <!-- Details will be displayed here -->
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        // Event listener for table row click
        $('table tbody tr').click(function () {
            var dated = $(this).data('dated');
            var vno = $(this).data('vno');
            var description = $(this).data('description');
            var debit = $(this).data('debit');
            var credit = $(this).data('credit');

            // Update modal content
            $('#modalBody').html("<p><strong>Date:</strong> " + dated + "</p><p><strong>V.No:</strong> " + vno + "</p><p><strong>Description:</strong> " + description + "</p><p><strong>Debit:</strong> " + debit + "</p><p><strong>Credit:</strong> " + credit + "</p>");
        });
    });
</script>


<script type="text/javascript">
// Function to print the page
function printPage() {
  window.print(); // Open the print dialog
}
</script>
</div>
</body>
</html>
